---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-遅延モジュール検出レポート（Slow Module Detection Report）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 全項目が根拠付きのため、特に優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/webpack/plugins/slow-module-detection-plugin.ts` 行217-244（SlowModuleDetectionPlugin）
- E-02: `packages/next/src/build/webpack/plugins/slow-module-detection-plugin.ts` 行68-215（ModuleBuildTimeAnalyzer）
- E-03: `packages/next/src/build/webpack/plugins/slow-module-detection-plugin.ts` 行12（PATH_TRUNCATION_LENGTH = 120）
- E-04: `packages/next/src/build/webpack/plugins/slow-module-detection-plugin.ts` 行15（NODE_MODULES_PATH_PATTERN）
- E-05: `packages/next/src/build/webpack/plugins/slow-module-detection-plugin.ts` 行81-96（recordModuleBuildTime）
- E-06: `packages/next/src/build/webpack/plugins/slow-module-detection-plugin.ts` 行107-154（prepareReport）
- E-07: `packages/next/src/build/webpack/plugins/slow-module-detection-plugin.ts` 行156-214（generateReport）
- E-08: `packages/next/src/build/webpack-config.ts` 行921, 2197（有効化条件）
- E-09: `packages/next/src/server/config-shared.ts` 行805-810（設定型定義）
- E-10: `packages/next/src/build/webpack-config.ts` 行928（並列処理無効化警告）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SlowModuleDetectionPluginがwebpackプラグインとして動作 | E-01 | ○ |
| C-02 | buildTimeThresholdMsで閾値を設定 | E-05（行90） | ○ |
| C-03 | performance.now()でビルド時間を計測 | E-01（行225-236） | ○ |
| C-04 | finishModulesフックでレポート生成 | E-01（行239-241） | ○ |
| C-05 | issuerModuleで親モジュールを辿る | E-06（行116） | ○ |
| C-06 | PATH_TRUNCATION_LENGTHは120 | E-03 | ○ |
| C-07 | node_modulesパスはパッケージ名以降のみ表示 | E-04, E-02（行39-42） | ○ |
| C-08 | truncatePathで中間を...で省略 | E-02（行51-66） | ○ |
| C-09 | 循環依存検出時にInvariantエラー | E-06（行118-122） | ○ |
| C-10 | isFinalized後の記録でInvariantエラー | E-05（行84-88） | ○ |
| C-11 | 開始時刻不在時にInvariantエラー | E-01（行231-235） | ○ |
| C-12 | experimental.slowModuleDetectionで有効化 | E-08, E-09 | ○ |
| C-13 | devモードかつwebpack使用時のみ有効 | E-08（行921） | ○ |
| C-14 | 有効化時にwebpack並列処理が無効化される | E-10 | ○ |
| C-15 | 色分け: パス=青、時間=黄、ヘッダー=緑 | E-07（行176, 182, 208） | ○ |
| C-16 | ルートモジュール（親なし）からツリー表示 | E-07（行162-164） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 有効化条件（dev && webpack && experimental.slowModuleDetection）が正確か確認
- [ ] インポートチェーン構築ロジックが正確か確認
- [ ] エラーメッセージの内容がソースコードと一致するか確認
